<?php 
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * 货币
 * @author rain
 */
class WShop_Currency{
    
    public static function get_currencies(){
        return array_unique(
    		apply_filters( 'wshop_currencies',
    			array(
    				'AED' => __( 'United Arab Emirates dirham', WSHOP ),
    				'AFN' => __( 'Afghan afghani', WSHOP ),
    				'ALL' => __( 'Albanian lek', WSHOP ),
    				'AMD' => __( 'Armenian dram', WSHOP ),
    				'ANG' => __( 'Netherlands Antillean guilder', WSHOP ),
    				'AOA' => __( 'Angolan kwanza', WSHOP ),
    				'ARS' => __( 'Argentine peso', WSHOP ),
    				'AUD' => __( 'Australian dollar', WSHOP ),
    				'AWG' => __( 'Aruban florin', WSHOP ),
    				'AZN' => __( 'Azerbaijani manat', WSHOP ),
    				'BAM' => __( 'Bosnia and Herzegovina convertible mark', WSHOP ),
    				'BBD' => __( 'Barbadian dollar', WSHOP ),
    				'BDT' => __( 'Bangladeshi taka', WSHOP ),
    				'BGN' => __( 'Bulgarian lev', WSHOP ),
    				'BHD' => __( 'Bahraini dinar', WSHOP ),
    				'BIF' => __( 'Burundian franc', WSHOP ),
    				'BMD' => __( 'Bermudian dollar', WSHOP ),
    				'BND' => __( 'Brunei dollar', WSHOP ),
    				'BOB' => __( 'Bolivian boliviano', WSHOP ),
    				'BRL' => __( 'Brazilian real', WSHOP ),
    				'BSD' => __( 'Bahamian dollar', WSHOP ),
    				'BTC' => __( 'Bitcoin', WSHOP ),
    				'BTN' => __( 'Bhutanese ngultrum', WSHOP ),
    				'BWP' => __( 'Botswana pula', WSHOP ),
    				'BYR' => __( 'Belarusian ruble', WSHOP ),
    				'BZD' => __( 'Belize dollar', WSHOP ),
    				'CAD' => __( 'Canadian dollar', WSHOP ),
    				'CDF' => __( 'Congolese franc', WSHOP ),
    				'CHF' => __( 'Swiss franc', WSHOP ),
    				'CLP' => __( 'Chilean peso', WSHOP ),
    				'CNY' => __( 'Chinese yuan', WSHOP ),
    				'COP' => __( 'Colombian peso', WSHOP ),
    				'CRC' => __( 'Costa Rican col&oacute;n', WSHOP ),
    				'CUC' => __( 'Cuban convertible peso', WSHOP ),
    				'CUP' => __( 'Cuban peso', WSHOP ),
    				'CVE' => __( 'Cape Verdean escudo', WSHOP ),
    				'CZK' => __( 'Czech koruna', WSHOP ),
    				'DJF' => __( 'Djiboutian franc', WSHOP ),
    				'DKK' => __( 'Danish krone', WSHOP ),
    				'DOP' => __( 'Dominican peso', WSHOP ),
    				'DZD' => __( 'Algerian dinar', WSHOP ),
    				'EGP' => __( 'Egyptian pound', WSHOP ),
    				'ERN' => __( 'Eritrean nakfa', WSHOP ),
    				'ETB' => __( 'Ethiopian birr', WSHOP ),
    				'EUR' => __( 'Euro', WSHOP ),
    				'FJD' => __( 'Fijian dollar', WSHOP ),
    				'FKP' => __( 'Falkland Islands pound', WSHOP ),
    				'GBP' => __( 'Pound sterling', WSHOP ),
    				'GEL' => __( 'Georgian lari', WSHOP ),
    				'GGP' => __( 'Guernsey pound', WSHOP ),
    				'GHS' => __( 'Ghana cedi', WSHOP ),
    				'GIP' => __( 'Gibraltar pound', WSHOP ),
    				'GMD' => __( 'Gambian dalasi', WSHOP ),
    				'GNF' => __( 'Guinean franc', WSHOP ),
    				'GTQ' => __( 'Guatemalan quetzal', WSHOP ),
    				'GYD' => __( 'Guyanese dollar', WSHOP ),
    				'HKD' => __( 'Hong Kong dollar', WSHOP ),
    				'HNL' => __( 'Honduran lempira', WSHOP ),
    				'HRK' => __( 'Croatian kuna', WSHOP ),
    				'HTG' => __( 'Haitian gourde', WSHOP ),
    				'HUF' => __( 'Hungarian forint', WSHOP ),
    				'IDR' => __( 'Indonesian rupiah', WSHOP ),
    				'ILS' => __( 'Israeli new shekel', WSHOP ),
    				'IMP' => __( 'Manx pound', WSHOP ),
    				'INR' => __( 'Indian rupee', WSHOP ),
    				'IQD' => __( 'Iraqi dinar', WSHOP ),
    				'IRR' => __( 'Iranian rial', WSHOP ),
    				'ISK' => __( 'Icelandic kr&oacute;na', WSHOP ),
    				'JEP' => __( 'Jersey pound', WSHOP ),
    				'JMD' => __( 'Jamaican dollar', WSHOP ),
    				'JOD' => __( 'Jordanian dinar', WSHOP ),
    				'JPY' => __( 'Japanese yen', WSHOP ),
    				'KES' => __( 'Kenyan shilling', WSHOP ),
    				'KGS' => __( 'Kyrgyzstani som', WSHOP ),
    				'KHR' => __( 'Cambodian riel', WSHOP ),
    				'KMF' => __( 'Comorian franc', WSHOP ),
    				'KPW' => __( 'North Korean won', WSHOP ),
    				'KRW' => __( 'South Korean won', WSHOP ),
    				'KWD' => __( 'Kuwaiti dinar', WSHOP ),
    				'KYD' => __( 'Cayman Islands dollar', WSHOP ),
    				'KZT' => __( 'Kazakhstani tenge', WSHOP ),
    				'LAK' => __( 'Lao kip', WSHOP ),
    				'LBP' => __( 'Lebanese pound', WSHOP ),
    				'LKR' => __( 'Sri Lankan rupee', WSHOP ),
    				'LRD' => __( 'Liberian dollar', WSHOP ),
    				'LSL' => __( 'Lesotho loti', WSHOP ),
    				'LYD' => __( 'Libyan dinar', WSHOP ),
    				'MAD' => __( 'Moroccan dirham', WSHOP ),
    				'MDL' => __( 'Moldovan leu', WSHOP ),
    				'MGA' => __( 'Malagasy ariary', WSHOP ),
    				'MKD' => __( 'Macedonian denar', WSHOP ),
    				'MMK' => __( 'Burmese kyat', WSHOP ),
    				'MNT' => __( 'Mongolian t&ouml;gr&ouml;g', WSHOP ),
    				'MOP' => __( 'Macanese pataca', WSHOP ),
    				'MRO' => __( 'Mauritanian ouguiya', WSHOP ),
    				'MUR' => __( 'Mauritian rupee', WSHOP ),
    				'MVR' => __( 'Maldivian rufiyaa', WSHOP ),
    				'MWK' => __( 'Malawian kwacha', WSHOP ),
    				'MXN' => __( 'Mexican peso', WSHOP ),
    				'MYR' => __( 'Malaysian ringgit', WSHOP ),
    				'MZN' => __( 'Mozambican metical', WSHOP ),
    				'NAD' => __( 'Namibian dollar', WSHOP ),
    				'NGN' => __( 'Nigerian naira', WSHOP ),
    				'NIO' => __( 'Nicaraguan c&oacute;rdoba', WSHOP ),
    				'NOK' => __( 'Norwegian krone', WSHOP ),
    				'NPR' => __( 'Nepalese rupee', WSHOP ),
    				'NZD' => __( 'New Zealand dollar', WSHOP ),
    				'OMR' => __( 'Omani rial', WSHOP ),
    				'PAB' => __( 'Panamanian balboa', WSHOP ),
    				'PEN' => __( 'Peruvian nuevo sol', WSHOP ),
    				'PGK' => __( 'Papua New Guinean kina', WSHOP ),
    				'PHP' => __( 'Philippine peso', WSHOP ),
    				'PKR' => __( 'Pakistani rupee', WSHOP ),
    				'PLN' => __( 'Polish z&#x142;oty', WSHOP ),
    				'PRB' => __( 'Transnistrian ruble', WSHOP ),
    				'PYG' => __( 'Paraguayan guaran&iacute;', WSHOP ),
    				'QAR' => __( 'Qatari riyal', WSHOP ),
    				'RON' => __( 'Romanian leu', WSHOP ),
    				'RSD' => __( 'Serbian dinar', WSHOP ),
    				'RUB' => __( 'Russian ruble', WSHOP ),
    				'RWF' => __( 'Rwandan franc', WSHOP ),
    				'SAR' => __( 'Saudi riyal', WSHOP ),
    				'SBD' => __( 'Solomon Islands dollar', WSHOP ),
    				'SCR' => __( 'Seychellois rupee', WSHOP ),
    				'SDG' => __( 'Sudanese pound', WSHOP ),
    				'SEK' => __( 'Swedish krona', WSHOP ),
    				'SGD' => __( 'Singapore dollar', WSHOP ),
    				'SHP' => __( 'Saint Helena pound', WSHOP ),
    				'SLL' => __( 'Sierra Leonean leone', WSHOP ),
    				'SOS' => __( 'Somali shilling', WSHOP ),
    				'SRD' => __( 'Surinamese dollar', WSHOP ),
    				'SSP' => __( 'South Sudanese pound', WSHOP ),
    				'STD' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe dobra', WSHOP ),
    				'SYP' => __( 'Syrian pound', WSHOP ),
    				'SZL' => __( 'Swazi lilangeni', WSHOP ),
    				'THB' => __( 'Thai baht', WSHOP ),
    				'TJS' => __( 'Tajikistani somoni', WSHOP ),
    				'TMT' => __( 'Turkmenistan manat', WSHOP ),
    				'TND' => __( 'Tunisian dinar', WSHOP ),
    				'TOP' => __( 'Tongan pa&#x2bb;anga', WSHOP ),
    				'TRY' => __( 'Turkish lira', WSHOP ),
    				'TTD' => __( 'Trinidad and Tobago dollar', WSHOP ),
    				'TWD' => __( 'New Taiwan dollar', WSHOP ),
    				'TZS' => __( 'Tanzanian shilling', WSHOP ),
    				'UAH' => __( 'Ukrainian hryvnia', WSHOP ),
    				'UGX' => __( 'Ugandan shilling', WSHOP ),
    				'USD' => __( 'United States dollar', WSHOP ),
    				'UYU' => __( 'Uruguayan peso', WSHOP ),
    				'UZS' => __( 'Uzbekistani som', WSHOP ),
    				'VEF' => __( 'Venezuelan bol&iacute;var', WSHOP ),
    				'VND' => __( 'Vietnamese &#x111;&#x1ed3;ng', WSHOP ),
    				'VUV' => __( 'Vanuatu vatu', WSHOP ),
    				'WST' => __( 'Samoan t&#x101;l&#x101;', WSHOP ),
    				'XAF' => __( 'Central African CFA franc', WSHOP ),
    				'XCD' => __( 'East Caribbean dollar', WSHOP ),
    				'XOF' => __( 'West African CFA franc', WSHOP ),
    				'XPF' => __( 'CFP franc', WSHOP ),
    				'YER' => __( 'Yemeni rial', WSHOP ),
    				'ZAR' => __( 'South African rand', WSHOP ),
    				'ZMW' => __( 'Zambian kwacha', WSHOP ),
    			)
    		)
    	);
    }

    public static function get_currency_symbol( $currency ) {
        $symbols = apply_filters( 'wshop_currency_symbols', array(
            'AED' => '&#x62f;.&#x625;',
            'AFN' => '&#x60b;',
            'ALL' => 'L',
            'AMD' => 'AMD',
            'ANG' => '&fnof;',
            'AOA' => 'Kz',
            'ARS' => '&#36;',
            'AUD' => '&#36;',
            'AWG' => '&fnof;',
            'AZN' => 'AZN',
            'BAM' => 'KM',
            'BBD' => '&#36;',
            'BDT' => '&#2547;&nbsp;',
            'BGN' => '&#1083;&#1074;.',
            'BHD' => '.&#x62f;.&#x628;',
            'BIF' => 'Fr',
            'BMD' => '&#36;',
            'BND' => '&#36;',
            'BOB' => 'Bs.',
            'BRL' => '&#82;&#36;',
            'BSD' => '&#36;',
            'BTC' => '&#3647;',
            'BTN' => 'Nu.',
            'BWP' => 'P',
            'BYR' => 'Br',
            'BZD' => '&#36;',
            'CAD' => '&#36;',
            'CDF' => 'Fr',
            'CHF' => '&#67;&#72;&#70;',
            'CLP' => '&#36;',
            'CNY' => '&yen;',
            'COP' => '&#36;',
            'CRC' => '&#x20a1;',
            'CUC' => '&#36;',
            'CUP' => '&#36;',
            'CVE' => '&#36;',
            'CZK' => '&#75;&#269;',
            'DJF' => 'Fr',
            'DKK' => 'DKK',
            'DOP' => 'RD&#36;',
            'DZD' => '&#x62f;.&#x62c;',
            'EGP' => 'EGP',
            'ERN' => 'Nfk',
            'ETB' => 'Br',
            'EUR' => '&euro;',
            'FJD' => '&#36;',
            'FKP' => '&pound;',
            'GBP' => '&pound;',
            'GEL' => '&#x10da;',
            'GGP' => '&pound;',
            'GHS' => '&#x20b5;',
            'GIP' => '&pound;',
            'GMD' => 'D',
            'GNF' => 'Fr',
            'GTQ' => 'Q',
            'GYD' => '&#36;',
            'HKD' => '&#36;',
            'HNL' => 'L',
            'HRK' => 'Kn',
            'HTG' => 'G',
            'HUF' => '&#70;&#116;',
            'IDR' => 'Rp',
            'ILS' => '&#8362;',
            'IMP' => '&pound;',
            'INR' => '&#8377;',
            'IQD' => '&#x639;.&#x62f;',
            'IRR' => '&#xfdfc;',
            'ISK' => 'kr.',
            'JEP' => '&pound;',
            'JMD' => '&#36;',
            'JOD' => '&#x62f;.&#x627;',
            'JPY' => '&yen;',
            'KES' => 'KSh',
            'KGS' => '&#x441;&#x43e;&#x43c;',
            'KHR' => '&#x17db;',
            'KMF' => 'Fr',
            'KPW' => '&#x20a9;',
            'KRW' => '&#8361;',
            'KWD' => '&#x62f;.&#x643;',
            'KYD' => '&#36;',
            'KZT' => 'KZT',
            'LAK' => '&#8365;',
            'LBP' => '&#x644;.&#x644;',
            'LKR' => '&#xdbb;&#xdd4;',
            'LRD' => '&#36;',
            'LSL' => 'L',
            'LYD' => '&#x644;.&#x62f;',
            'MAD' => '&#x62f;. &#x645;.',
            'MAD' => '&#x62f;.&#x645;.',
            'MDL' => 'L',
            'MGA' => 'Ar',
            'MKD' => '&#x434;&#x435;&#x43d;',
            'MMK' => 'Ks',
            'MNT' => '&#x20ae;',
            'MOP' => 'P',
            'MRO' => 'UM',
            'MUR' => '&#x20a8;',
            'MVR' => '.&#x783;',
            'MWK' => 'MK',
            'MXN' => '&#36;',
            'MYR' => '&#82;&#77;',
            'MZN' => 'MT',
            'NAD' => '&#36;',
            'NGN' => '&#8358;',
            'NIO' => 'C&#36;',
            'NOK' => '&#107;&#114;',
            'NPR' => '&#8360;',
            'NZD' => '&#36;',
            'OMR' => '&#x631;.&#x639;.',
            'PAB' => 'B/.',
            'PEN' => 'S/.',
            'PGK' => 'K',
            'PHP' => '&#8369;',
            'PKR' => '&#8360;',
            'PLN' => '&#122;&#322;',
            'PRB' => '&#x440;.',
            'PYG' => '&#8370;',
            'QAR' => '&#x631;.&#x642;',
            'RMB' => '&yen;',
            'RON' => 'lei',
            'RSD' => '&#x434;&#x438;&#x43d;.',
            'RUB' => '&#8381;',
            'RWF' => 'Fr',
            'SAR' => '&#x631;.&#x633;',
            'SBD' => '&#36;',
            'SCR' => '&#x20a8;',
            'SDG' => '&#x62c;.&#x633;.',
            'SEK' => '&#107;&#114;',
            'SGD' => '&#36;',
            'SHP' => '&pound;',
            'SLL' => 'Le',
            'SOS' => 'Sh',
            'SRD' => '&#36;',
            'SSP' => '&pound;',
            'STD' => 'Db',
            'SYP' => '&#x644;.&#x633;',
            'SZL' => 'L',
            'THB' => '&#3647;',
            'TJS' => '&#x405;&#x41c;',
            'TMT' => 'm',
            'TND' => '&#x62f;.&#x62a;',
            'TOP' => 'T&#36;',
            'TRY' => '&#8378;',
            'TTD' => '&#36;',
            'TWD' => '&#78;&#84;&#36;',
            'TZS' => 'Sh',
            'UAH' => '&#8372;',
            'UGX' => 'UGX',
            'USD' => '&#36;',
            'UYU' => '&#36;',
            'UZS' => 'UZS',
            'VEF' => 'Bs F',
            'VND' => '&#8363;',
            'VUV' => 'Vt',
            'WST' => 'T',
            'XAF' => 'Fr',
            'XCD' => '&#36;',
            'XOF' => 'Fr',
            'XPF' => 'Fr',
            'YER' => '&#xfdfc;',
            'ZAR' => '&#82;',
            'ZMW' => 'ZK',
        ) );
    
        $currency_symbol = isset( $symbols[ $currency ] ) ? $symbols[ $currency ] : '';
    
        return apply_filters( 'wshop_currency_symbol', $currency_symbol, $currency );
    }
}
?>