<?php 
define('WP_USE_THEMES', false);
require_once('../../../wp-load.php');
$request=array(
    'appid'     => edd_get_option('xh_wechat_payment_edd_appid'), //必须的，APPID
    'out_trade_order'=> $_GET['order_id'], //网站订单号(out_trade_order，open_order_id 二选一)
    'time'      => time(),//必须的，当前时间戳，根据此字段判断订单请求是否已超时，防止第三方攻击服务器
    'nonce_str' => str_shuffle(time())//必须的，随机字符串，作用：1.避免服务器缓存，2.防止安全密钥被猜测出来
);
$url = edd_get_option('xh_wechat_payment_edd_transaction_url').'/payment/query.html';
$appsecret=edd_get_option('xh_wechat_payment_edd_appsecret');
$request['hash'] =  generate_xh_hash($request,$appsecret);
$response = http_post($url, http_build_query($request));
$result       = $response?json_decode($response,true):null;
if($result['data']['status']=='OD'){
	echo 'complete';
	exit;
}else{
	echo 'paidding';
	exit;
}
function http_post($url,$data){
    if(!function_exists('curl_init')){
        throw new Exception('php未安装curl组件',500);
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch,CURLOPT_URL, $url);
    curl_setopt($ch,CURLOPT_REFERER,get_option('siteurl'));
    curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,FALSE);
    curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,FALSE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $response = curl_exec($ch);
    $httpStatusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error=curl_error($ch);
    curl_close($ch);
    if($httpStatusCode!=200){
        throw new Exception("invalid httpstatus:{$httpStatusCode} ,response:$response,detail_error:".$error,$httpStatusCode);
    }

    return $response;
}

function generate_xh_hash(array $datas,$hashkey){
    ksort($datas);
    reset($datas);
    $arg  = '';
    foreach ($datas as $key=>$val){
        if($key=='hash'||is_null($val)||$val===''){continue;}
        if($arg){$arg.='&';}
        $arg.="$key=$val";
    }
    return md5($arg.$hashkey);
}
?>