<?php
if (! defined ( 'ABSPATH' )) exit ();
class XH_Wechat_Payment_EDD_Api{
    public $id = 'xh_wechat_payment_edd';

    public function __construct(){
        add_filter( 'edd_accepted_payment_icons', array( $this, 'register_payment_icon' ), 10, 1 );
    }

    public function init(){
        if(!function_exists('edd_get_option')){
            add_action ( 'admin_notices',function(){
                ?>
                <div class="notice notice-error is-dismissible"><b> Wechat:</b><p>请启用EDD插件!</p></div>
                <?php
            });
            return;
        }
        $appkey =edd_get_option('xh_wechat_payment_edd_appsecret');

        //return
        if(isset($_GET['payment_id'])&&isset($_GET['hash'])){
            $hash = $this->generate_xh_hash(array(
                    'payment_id'=>$_GET['payment_id']
            ),$appkey);

            if($hash==$_GET['hash']){
                edd_empty_cart();
                wp_redirect(apply_filters('edd_success_page_redirect', edd_get_success_page_uri(),$_GET['payment_id']));
                exit;
            }
        }

        //notify
        $data = $_POST;
        if(!isset($data['hash']) ||!isset($data['trade_order_id'])){
            return 'Error';
        }

        if(isset($data['plugins'])&&$data['plugins']!='edd-wechat'){
            return 'Error';
        }

        $hash = $this->generate_xh_hash($data,$appkey);
        if($data['hash']!=$hash){
            return 'hash Error';
        }
        $order_id = explode("_",$data['trade_order_id'])[1];
        try{
            if(!edd_is_payment_complete($order_id)){
                $transaction_id = isset($data['transacton_id'])?$data['transacton_id']:'';
                if($transaction_id){
                    update_post_meta($order_id, '_edd_payment_transaction_id', $transaction_id);
                }

                edd_update_payment_status($order_id, 'complete');
            }
        }catch(Exception $e){
            //looger
            $logger = new WC_Logger();
            $logger->add( 'xh_wedchat_payment', $e->getMessage() );

            echo 'Error';
            exit;
        }

        echo 'success';
        exit;
    }

    public function register_activation_hook(){
        $val =edd_get_option('xh_wechat_payment_edd_title');
        if(empty($val)){
            edd_update_option('xh_wechat_payment_edd_title',__('Wechat Payment',XH_WECHAT_PAYMENT_EDD));
        }

        $val =edd_get_option('xh_wechat_payment_edd_appid');
        if(empty($val)){
            edd_update_option('xh_wechat_payment_edd_appid','');
        }

        $val =edd_get_option('xh_wechat_payment_edd_appsecret');
        if(empty($val)){
            edd_update_option('xh_wechat_payment_edd_appsecret','');
        }

        $val =edd_get_option('xh_wechat_payment_edd_transaction_url');
        if(empty($val)){
            edd_update_option('xh_wechat_payment_edd_transaction_url','https://api.xunhupay.com');
        }

        $val =edd_get_option('xh_wechat_payment_edd_exchange_rate');
        if(empty($val)){
            edd_update_option('xh_wechat_payment_edd_exchange_rate','1');
        }
    }

    public function edd_settings_gateways($settings){
        $options=array(
            'xh_wechat_payment_edd_settings'=>array(
                'id'   => 'xh_wechat_payment_edd_header',
                'name' => '<h3>' . __( 'Wechat Payment Settings', XH_WECHAT_PAYMENT_EDD ) . '</h3>',
                'desc' => '',
                'type' => 'header',
            ),
            'xh_wechat_payment_edd_title'=>array(
                'id' => 'xh_wechat_payment_edd_title',
                'name' =>  __( 'Title', XH_WECHAT_PAYMENT_EDD ),
                'type' => 'text'
            ),
			'xh_wechat_payment_edd_appid' => array(
			        'id'=>'xh_wechat_payment_edd_appid',
					'name'       => __( 'APP ID', XH_WECHAT_PAYMENT_EDD ),
					'type'        => 'text',
			         'default'=>'2147483647',
                     'desc'=>'帮助文档：https://www.xunhupay.com/114.html'
			),
			'xh_wechat_payment_edd_appsecret' => array(
			        'id'=>'xh_wechat_payment_edd_appsecret',
					'name'       => __( 'APP Secret', XH_WECHAT_PAYMENT_EDD ),
					'type'        => 'text',
			    'default'=>'160130736b1ac0d54ed7abe51e44840b',

			),
			'xh_wechat_payment_edd_transaction_url' => array(
			    'id'=>'xh_wechat_payment_edd_transaction_url',
					'name'       => __( 'Transaction Url', XH_WECHAT_PAYMENT_EDD ),
					'type'        => 'text',
			        'default'=>'https://api.xunhupay.com',
			    'desc' =>''
			),
            'xh_wechat_payment_edd_exchange_rate'=>array(
                'id' => 'xh_wechat_payment_edd_exchange_rate',
                'name' => __( 'exchange rate', XH_WECHAT_PAYMENT_EDD ),
                'placeholder'=>'1',
                'desc'=>__( 'Please set current currency against Chinese Yuan exchange rate,default 1.', XH_WECHAT_PAYMENT_EDD ),
                'type' => 'text'
            )
        );

        $settings[$this->id]=$options;
        return $settings;
    }

    private function http_post($url,$data){
        if(!function_exists('curl_init')){
            throw new Exception('php未安装curl组件',500);
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch,CURLOPT_REFERER,get_option('siteurl'));
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,FALSE);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,FALSE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        $response = curl_exec($ch);
        $httpStatusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error=curl_error($ch);
        curl_close($ch);
        if($httpStatusCode!=200){
            throw new Exception("invalid httpstatus:{$httpStatusCode} ,response:$response,detail_error:".$error,$httpStatusCode);
        }

        return $response;
    }

    public function generate_xh_hash(array $datas,$hashkey){
        ksort($datas);
        reset($datas);
        $arg  = '';
        foreach ($datas as $key=>$val){
            if($key=='hash'||is_null($val)||$val===''){continue;}
            if($arg){$arg.='&';}
            $arg.="$key=$val";
        }
        return md5($arg.$hashkey);
    }

    private function is_wechat_app(){
        return strripos($_SERVER['HTTP_USER_AGENT'],'micromessenger');
    }

    public function register_payment_icon( $payment_icons ) {
        $payment_icons[XH_WECHAT_PAYMENT_EDD_URL.'/images/icon.png'] =__('Wechat Payment',XH_WECHAT_PAYMENT_EDD);

        return $payment_icons;
    }

    public function currency_filter_before( $formatted, $currency, $price){
        if($currency=='CNY'){
            $formatted = '&yen;' . ' ' . $price;
        }
        return $formatted;
    }

    public function currency_filter_after( $formatted, $currency, $price){
       if($currency=='CNY'){
            $formatted = $price . ' ' . '&yen;';
       }
       return $formatted;
    }

    public function plugin_action_links($links) {
        return array_merge ( array (
            'settings' => '<a href="' . admin_url ( 'edit.php?post_type=download&page=edd-settings&tab=gateways&section='.$this->id ) . '">'.__('Settings',XH_WECHAT_PAYMENT_EDD).'</a>'
        ), $links );
    }

    public function edd_currency_symbol($symbol, $currency ){
        if($currency=='CNY'){
            $symbol= '&yen;';
        }

        return $symbol;
    }
    /**
     *
     * @param array $order
     * @return string
     */
    public function edd_gateway($purchase_data){
        if( ! wp_verify_nonce( $purchase_data['gateway_nonce'], 'edd-gateway' ) ) {
    		wp_die( __( 'Nonce verification has failed', XH_WECHAT_PAYMENT_EDD ), __( 'Error',XH_WECHAT_PAYMENT_EDD ), array( 'response' => 403 ) );
    		return;
    	}

    	// Collect payment data
    	$payment_data = array(
    		'price'         => $purchase_data['price'],
    		'date'          => $purchase_data['date'],
    		'user_email'    => $purchase_data['user_email'],
    		'purchase_key'  => $purchase_data['purchase_key'],
    		'currency'      => edd_get_currency(),
    		'downloads'     => $purchase_data['downloads'],
    		'user_info'     => $purchase_data['user_info'],
    		'cart_details'  => $purchase_data['cart_details'],
    		'gateway'       => $purchase_data['post_data']['edd-gateway'],
    		'status'        => ! empty( $purchase_data['buy_now'] ) ? 'private' : 'pending'
    	);

	    $payment_id = edd_insert_payment( $payment_data );
        if($payment_id===false){
             edd_set_error(__( 'Payment Error', XH_Wechat_Payment), __('Ops!Something is wrong',XH_Wechat_Payment));
            edd_record_gateway_error('Payment Error',__('Ops!Something is wrong',XH_Wechat_Payment), $payment_id );
            edd_send_back_to_checkout( '?payment-mode=' . $purchase_data['post_data']['edd-gateway'] );
            return;
        }

        $payment_data['order_id']=$payment_id;

        $exchange_rate =floatval(edd_get_option('xh_wechat_payment_edd_exchange_rate',1));
        if($exchange_rate<=0){
            $exchange_rate=1;
        }

        $total_fee = round(floatval($payment_data['price'])*$exchange_rate, 2);
        $hashkey          = edd_get_option('xh_wechat_payment_edd_appsecret');
        $params = array(
                'payment_id'=>$payment_id
        );

        $params['hash']=$this->generate_xh_hash($params, $hashkey);

        $siteurl = rtrim(home_url(),'/');
        $posi =strripos($siteurl, '/');
        //若是二级目录域名，需要以“/”结尾，否则会出现403跳转
        if($posi!==false&&$posi>7){
            $siteurl.='/';
        }
        $trade_order_id = date("YmdH")."_".$payment_data['order_id'];
        $data=array(
            'version'   => '1.1',//api version
            'plugins'   => 'edd-wechat',
            'appid'     => edd_get_option('xh_wechat_payment_edd_appid'),
            'trade_order_id'=> $trade_order_id,
            'total_fee' => $total_fee,
            'title'     => $this->get_order_title($payment_data),
            'time'      => time(),
            'notify_url'=> $siteurl,
            'return_url'=>  $siteurl."?".http_build_query($params),
            'callback_url'=>edd_get_checkout_uri(),
            'nonce_str' => str_shuffle(time())
        );
        if(wp_is_mobile()){
            $data['type'] = 'WAP';
            $data['wap_name'] = home_url();
            $data['wap_url'] = home_url();
        }

        $data['hash']     = $this->generate_xh_hash($data,$hashkey);
        $url              = edd_get_option('xh_wechat_payment_edd_transaction_url').'/payment/do.html';

        try {
            $response     = $this->http_post($url, json_encode($data));
            $result       = $response?json_decode($response,true):null;
            if(!$result){
                throw new Exception($response,500);
            }

            if($result['errcode']!=0){
                throw new Exception($result['errmsg'],500);
            }
            //edd_empty_cart();
            if(wp_is_mobile()){
                wp_redirect( $result['url']);
                exit;
            }
            $url =$result['url_qrcode'];
            ?>
			<!DOCTYPE html>
			<html>
			<head>
		    <meta charset="utf-8">
		    <meta http-equiv="X-UA-Compatible" content="IE=edge">
		    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
		    <meta name="keywords" content="">
		    <meta name="description" content="">   
		    <title>微信支付收银台</title>
		    <style>
		         *{margin:0;padding:0;}
		          body{background: #f2f2f4;}
		         .clearfix:after { content: "."; display: block; height: 0; clear: both; visibility: hidden; }
		        .clearfix { display: inline-block; }
		        * html .clearfix { height: 1%; }
		        .clearfix { display: block; }
		          .xh-title{height:75px;line-height:75px;text-align:center;font-size:30px;font-weight:300;border-bottom:2px solid #eee;background: #fff;}
		          .qrbox{max-width: 900px;margin: 0 auto;padding:85px 20px 20px 50px;}
		          
		          .qrbox .left{width: 40%;
		            float: left;    
		             display: block;
		            margin: 0px auto;}
		          .qrbox .left .qrcon{
		            border-radius: 10px;
		            background: #fff;
		            overflow: visible;
		            text-align: center;
		            padding-top:25px;
		            color: #555;
		            box-shadow: 0 3px 3px 0 rgba(0, 0, 0, .05);
		            vertical-align: top;
		            -webkit-transition: all .2s linear;
		            transition: all .2s linear;
		          }
		            .qrbox .left .qrcon .logo{width: 100%;}
		            .qrbox .left .qrcon .title{font-size: 16px;margin: 10px auto;width: 100%;}
		            .qrbox .left .qrcon .price{font-size: 22px;margin: 0px auto;width: 100%;}
		            .qrbox .left .qrcon .bottom{border-radius: 0 0 10px 10px;
		            width: 100%;
		            background: #32343d;
		            color: #f2f2f2;padding:15px 0px;text-align: center;font-size: 14px;}
		           .qrbox .sys{width: 60%;float: right;text-align: center;padding-top:20px;font-size: 12px;color: #ccc}
		           .qrbox img{max-width: 100%;}
		           @media (max-width : 767px){
		        .qrbox{padding:20px;}
		            .qrbox .left{width: 90%;float: none;}   
		            .qrbox .sys{display: none;}
		           }
		           
		           @media (max-width : 320px){
		
		          }
		          @media ( min-width: 321px) and ( max-width:375px ){
		
		          }
		    </style>
		    </head>
		    
		    <body>
		     <div class="xh-title">微信支付收银台</div>
		      <div class="qrbox clearfix">
		      <div class="left">
		         <div class="qrcon">
		           <h5><img src="<?php echo plugin_dir_url(__FILE__ ) ?>images/wechat/logo.png" alt=""></h5>
		             <div class="title"><?php echo $this->get_order_title($payment_data) ?></div>
		             <div class="price">￥<?php echo $total_fee ?></div>
		             <div align="center"><div id="wechat_qrcode" style="width: 250px;height: 250px;"><img src="<?php echo $url;?>"/></div></div>
		             <div class="bottom">
		                 	请使用微信扫一扫<br/>
		    				扫描二维码支付
		             </div>
		         </div>
		         
		  </div>
		     <div class="sys"><img src="<?php echo plugin_dir_url(__FILE__ ) ?>images/wechat/wechat-sys.png" alt=""></div>
		  </div>
			 <script src="<?php echo $siteurl ?>/wp-includes/js/jquery/jquery.js"></script>
		     <script type="text/javascript">
		     (function($){
		    		window.view={
						query:function () {
					        $.ajax({
					            type: "POST",
					            url: "<?php echo plugin_dir_url(__FILE__ ).'query.php?order_id='.$trade_order_id ?>",
					            timeout:6000,
					            cache:false,
					            dataType:'text',
					            success:function(e){
					            		if (e && e.indexOf('complete')!==-1) {
		    		                    window.location.href = "<?php echo edd_get_success_page_uri() ?>";
		    		                    return;
		    		                }
					                setTimeout(function(){window.view.query();}, 2000);
					            },
					            error:function(){
					            	 setTimeout(function(){window.view.query();}, 2000);
					            }
					        });
					    }
		    		};
		             setTimeout(function(){window.view.query();}, 2000);
		    	})(jQuery);
		    	</script>
			</body>
		</html>
			<?php
            exit;
        } catch (Exception $e) {
             edd_set_error(__( 'Payment Error', XH_Wechat_Payment), "errcode:{$e->getCode()},errmsg:{$e->getMessage()}");
            edd_record_gateway_error(__( 'Payment Error', XH_Wechat_Payment),"errcode:{$e->getCode()},errmsg:{$e->getMessage()}", $payment_id );
            edd_send_back_to_checkout( '?payment-mode=' . $purchase_data['post_data']['edd-gateway'] );
            exit;
        }
    }

    public  function edd_settings_sections_gateways( $gateway_sections ) {
        $gateway_sections[$this->id] =  __('Wechat Payment',XH_WECHAT_PAYMENT_EDD) ;

        return $gateway_sections;
    }

   public function edd_currencies( $currencies ) {
        $currencies['CNY'] = __('Chinese Yuan(&yen;)', XH_WECHAT_PAYMENT_EDD);

        return $currencies;
    }

    public function edd_payment_gateways($gateways){
        $gateways[$this->id] = array(
            'admin_label' => __('Wechat Payment',XH_WECHAT_PAYMENT_EDD),
            'checkout_label' =>edd_get_option('xh_wechat_payment_edd_title', __( 'Wechat Payment', XH_WECHAT_PAYMENT_EDD ))
        );
        return $gateways;
    }

    public function get_order_title($order, $limit = 98) {
        $subject = "#{$order['order_id']}";

        if($order['cart_details']&&count($order['cart_details'])>0){
            $index=0;
            foreach ($order['cart_details'] as $item){
                $subject.= "|{$item['name']}";
                if($index++>0){
                    $subject.='...';
                    break;
                }
            }
        }

        $title = mb_strimwidth($subject, 0, $limit,'utf-8');
        return apply_filters('xh-payment-get-order-title', $title,$order);
    }
}
?>
